{smcl}
{* *! version 1.0.0 5aug2014}{...}
{title:Title}

{phang}
{bf:dsimih drop} {hline 2} Remove from {cmd:e()} parts of or all dynamic simulation results created by {help dsimih create}


{marker syntax}{...}
{title:Syntax}

{p 8 17 2}
{cmd:dsimih drop} [{cmd:,} {opt reg:imes(rgmlist)} {opt m:axstep(#)} {opt set:ype(setype)} {opt erase}]

{synoptset 20 tabbed}{...}
{synopthdr}
{synoptline}
{synopt: {opt reg:imes(rgmlist)}}enumerates the regime encodings for which results should be erased{p_end}
{synopt: {opt m:axstep(#)}}removes results for forecast steps > #{p_end}
{synopt: {opt set:ype(setype)}}specifies the {it:setype} for which results should be erased{p_end}
{synopt: {opt erase}}erases all results{p_end}
{synoptline}
{p2colreset}{...}


{marker description}{...}
{title:Description}

{pstd}
{cmd:dsimih drop} removes from {cmd:e()} all or part of the dynamic simulation results created by {cmd:dsimih create}.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation, syntax elements}

{pstd}
This help entry uses terminology defined in {help svarih##abbreviations:svarih} and {help dsimih##abbreviations:dsimih}.


{marker options}{...}
{title:Options}

{phang}
{opt reg:imes(rgmlist)} pins down the regimes for which results should be erased.
If not other option is used, it removes all results for regimes {it:rgmlist} from {cmd:e()}.

{pmore}
{it:rgmlist} is a Stata {help numlist}.

{phang}
{opt m:axstep(#)} erases results for forecast steps >#.
If not other option is used, it removes forecast steps ># for all regimes from {cmd:e()}.

{phang}
{opt set:ype(setype)} specifies the type of standard error for which results should be erased.
If specified, {it:setype} may contain one of the tokens {opt a:symptotic}, {opt bs} and {opt bsp}.
If no other option is used, it removes all results for {it:setype}.

{phang}
{opt erase} removes all results from {cmd:e()}.
It replaces the contents of matrix e(dsimih) by a 1 x 1 matrix containing a missing value.
If option {opt erase} is used, no other options may be specified.


{marker remarks}{...}
{title:Remarks}

{pstd}
It may happen that you want to remove or replace dynamic simulation results from {cmd:e()}.
For example, you may have generated numbers for a very long forecast horizon and you are sure that a shorter horizon will be sufficient.
You may also want to replace existing bootstrap standard errors by ones that are based on a higher number of bootstrap replications.

{pstd}
The specifications of options {opt regimes()}, {opt maxstep()} and {opt setype()} are cumulative.
For example, if you specify {cmd:regimes(1 3) maxstep(3)}, all forecast steps >3 for regimes 1 3 are removed.
If you specify {cmd:regimes(1 3) setype(bs)}, all values for the standard error based on the residual bootstrap are removed for regimes 1 and 3.


{marker examples}{...}
{title:Examples}

{pstd}
Excecuting the following statements will change current {cmd:e()}-results.

{pstd}
Bootstrap replication numbers are set to values that are inappropriate for analysis but appropriate for quick execution of example statements.

{pstd}
Generate example estimates (see {help svarih examples}):

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata svarih examples bac_first , ereplace:. svarih examples bac_first , ereplace}{p_end}
{phang2}{stata dsimih describe , modelstats cmdline:. dsimih describe , modelstats cmdline}{p_end}

{phang2}{stata dsimih create:. dsimih create}{p_end}
{phang2}{stata "version 11.2: set seed 123456":. version 11.2: set seed 123456}{p_end}
{phang2}{stata dsimih create , bs fromb reps(10):. dsimih create , bs fromb reps(10)}{p_end}
{phang2}{stata "version 11.2: set seed 123456":. version 11.2: set seed 123456}{p_end}
{phang2}{stata dsimih create , bsp fromb reps(10):. dsimih create , bsp fromb reps(10)}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}

{pstd}
Recreating standard errors of {it:setype}=bs will not succeed if the new horizon is not longer than the existing one.
If we still want to replace the existing numbers with ones based on a higher number of replications, we have to drop the existing ones first.

{phang2}{stata dsimih create , bs fromb reps(20):. dsimih create , bs fromb reps(20)}{p_end}
{phang2}{stata dsimih drop , setype(bs):. dsimih drop , setype(bs)}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}
{phang2}{stata dsimih create , bs fromb reps(20):. dsimih create , bs fromb reps(20)}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}
{phang2}{stata dsimih describe, bootstrap nostep:. dsimih describe, bootstrap nostep}{p_end}

{pstd}
Increase horizon of {it:stats} and asymptotic standard errors.

{phang2}{stata dsimih create , step(20):. dsimih create , step(20)}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}

{pstd}
Options that restrict the scope of operations of {cmd:dsimih drop} are cumulative, i.e. joined with a logical 'AND'. The following sets the maximum horizon for asymtotic standard errors for regime one to 12. 

{phang2}{stata dsimih drop , regime(1) setype(asym) maxstep(12):. dsimih drop , regime(1) setype(asym) maxstep(12)}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}

{pstd}
The following sets the maximium horizon for everything to 6:

{phang2}{stata dsimih drop , maxstep(6):. dsimih drop , maxstep(6)}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}

{pstd}
The following drops numbers for an entire regime:

{phang2}{stata dsimih drop , regime(2):. dsimih drop , regime(2)}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}

{pstd}
Option {opt erase} erases all {cmd:dsimih} results:

{phang2}{stata dsimih drop , erase:. dsimih drop , erase}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}


{marker savedresults}{...}
{title:Saved results}

{pstd}
{cmd:dsimih drop} updates the following in {cmd:e()}:

{synoptset 20 tabbed}{...}
{p2col 5 20 24 0: Matrices}{p_end}
{synopt:{cmd:e(dsimih)}}matrix of dynamic simulation results{p_end}
{synopt:}{p_end}
{synopt:if the following matrices already exist:}{p_end}
{synopt:{cmd:e(dsimih_bs)}}detail for bootstrap replications for the residual bootstrap{p_end}
{synopt:{cmd:e(dsimih_bsp)}}detail for bootstrap replications for the parametric bootstrap{p_end}
{p2colreset}{...}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com

{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb irf:[TS] irf},
{helpb dsimih},
{helpb dsimih create},
{helpb dsimih table},
{helpb dsimih graph},
{helpb dsimih describe},
{helpb dsimih use},
{helpb dsimih etodta}
{p_end}

